package console;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public class SystemConsoleEntry {
	
    private Calendar m_time;
    private String m_text;
    final private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-M-d hh:mm:ss a");
    
    public SystemConsoleEntry(String text) {
		m_time = Calendar.getInstance();
		m_text = text;
    }
    
    // returns the time stamp of the console entry
    public Calendar getTime() {
    	return m_time;
    }
    
    // returns a string representation of the console entry
    public String getTimeString() {
    	return dateFormat.format(m_time.getTime());
    }
    
    // returns the text stored in the console entry
    public String getText() {
    	return m_text;
    }
    
}
